"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _lib = require("../lib");
var _watches = require("./watches");
var _watch = require("./watch");
var _es = require("./es");
var _alerts = require("./alerts");
var _alert = require("./alert");
var _accounts = require("./accounts");
var _account = require("./account");
var _searchguard = require("./searchguard");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function registerRoutes({
  router,
  clusterClient,
  logger,
  searchguardBackendService
}) {
  (0, _watches.registerWatchesRoutes)({
    router,
    clusterClient,
    fetchAllFromScroll: _lib.fetchAllFromScroll,
    logger: logger.get('signals-watches-routes')
  });
  (0, _watch.registerWatchRoutes)({
    router,
    clusterClient,
    logger: logger.get('signals-watch-routes')
  });
  (0, _es.registerEsRoutes)({
    router,
    clusterClient,
    logger: logger.get('signals-es-routes')
  });
  (0, _alerts.registerAlertsRoutes)({
    router,
    clusterClient,
    fetchAllFromScroll: _lib.fetchAllFromScroll,
    logger: logger.get('signals-alerts-routes')
  });
  (0, _alert.registerAlertRoutes)({
    router,
    clusterClient,
    logger: logger.get('signals-alert-routes')
  });
  (0, _accounts.registerAccountsRoutes)({
    router,
    clusterClient,
    fetchAllFromScroll: _lib.fetchAllFromScroll,
    logger: logger.get('signals-accounts-routes')
  });
  (0, _account.registerAccountRoutes)({
    router,
    clusterClient,
    logger: logger.get('signals-account-routes')
  });
  (0, _searchguard.registerSearchguardRoutes)({
    router,
    clusterClient,
    searchguardBackendService,
    logger: logger.get('signals-searchguard-routes')
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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